% this code plots the requested Pulse Length (1,5,10,20,50,100,200 and 1000
% ms ) against Measured Pulse Length for 10 repeated measurements.

t1=[14 21 21 30 26 21 19 28 18 18];
t5=[21 16 15 25 23 26 18 16 29 22];
t10=[21 20 19 29 20 20 21 20 20 19];
t20=[35 37 37 33 32 33 32 34 35 30];
t50=[64 62 69 65 61 61 62 64 69 62];
t100=[115 112 112 109 120 125 108 110 122 111];
t200=[220 215 222 218 220 220 225 218 222 220];
t1000=[1003 1007 1001 1009 1000 1003 1007 1001 1009 1000];

T=[1 5 10 20 50 100 200 1000];% requested Pulse Length (ms)
mean=[mean2(t1) mean2(t5) mean2(t10) mean2(t20) mean2(t50) mean2(t100) ...
    mean2(t200) mean2(t1000)];%mean of each measured pulses
S=[std(t1) std(t5) std(t10) std(t20) std(t50) std(t100) std(t200) ...
    std(t1000)];% standard deviation of all measured pulses

figure
errorbar(T,mean,S,'bo')
xlabel('Requested Pulse Length (ms)');ylabel('Measured Pulse Length (ms) ');

